using System;

namespace Server.Items
{
	public abstract class BaseSilkMiddleTorso : BaseClothing
	{
		public BaseSilkMiddleTorso( int itemID ) : this( itemID, 0 )
		{
		}

		public BaseSilkMiddleTorso( int itemID, int hue ) : base( itemID, Layer.MiddleTorso, hue )
		{
		}

        public BaseSilkMiddleTorso(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x1541, 0x1542 )]
	public class SilkBodySash : BaseSilkMiddleTorso
    {
        public override int BasePhysicalResistance { get { return 0; } }
        public override int BaseFireResistance { get { return 0; } }
        public override int BaseColdResistance { get { return 0; } }
        public override int BasePoisonResistance { get { return 2; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkBodySash() : this( 0 )
		{
		}

		[Constructable]
		public SilkBodySash( int hue ) : base( 0x1541, hue )
		{
			Weight = 1.0;
            Name = "Silk Body Sash";
		}

        public SilkBodySash(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x153d, 0x153e )]
	public class SilkFullApron : BaseSilkMiddleTorso
	{
        public override int BasePhysicalResistance { get { return 1; } }
        public override int BaseFireResistance { get { return 3; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 0; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkFullApron() : this( 0 )
		{
		}

		[Constructable]
		public SilkFullApron( int hue ) : base( 0x153d, hue )
		{
			Weight = 4.0;
            Name = "Silk Full Apron";
		}

        public SilkFullApron(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x1f7b, 0x1f7c )]
	public class SilkDoublet : BaseSilkMiddleTorso
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 1; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkDoublet() : this( 0 )
		{
		}

		[Constructable]
		public SilkDoublet( int hue ) : base( 0x1F7B, hue )
		{
			Weight = 2.0;
            Name = "Silk Doublet";
		}

        public SilkDoublet(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x1ffd, 0x1ffe )]
	public class SilkSurcoat : BaseSilkMiddleTorso
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 3; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkSurcoat() : this( 0 )
		{
		}

		[Constructable]
		public SilkSurcoat( int hue ) : base( 0x1FFD, hue )
		{
			Weight = 6.0;
            Name = "Silk Surcoat";
		}

        public SilkSurcoat(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Weight == 3.0 )
				Weight = 6.0;
		}
	}

	[Flipable( 0x1fa1, 0x1fa2 )]
    public class SilkTunic : BaseSilkMiddleTorso
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 3; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkTunic() : this( 0 )
		{
		}

		[Constructable]
		public SilkTunic( int hue ) : base( 0x1FA1, hue )
		{
			Weight = 5.0;
            Name = "Silk Tunic";
		}

        public SilkTunic(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x2310, 0x230F )]
	public class FormalSilkShirt : BaseSilkMiddleTorso
	{
        public override int BasePhysicalResistance { get { return 1; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public FormalSilkShirt() : this( 0 )
		{
		}

		[Constructable]
		public FormalSilkShirt( int hue ) : base( 0x2310, hue )
		{
			Weight = 1.0;
            Name = "Formal Silk Shirt";
		}

        public FormalSilkShirt(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version

			if ( Weight == 2.0 )
				Weight = 1.0;
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x1f9f, 0x1fa0 )]
	public class SilkJesterSuit : BaseSilkMiddleTorso
	{
        public override int BasePhysicalResistance { get { return 0; } }
        public override int BaseFireResistance { get { return 0; } }
        public override int BaseColdResistance { get { return 1; } }
        public override int BasePoisonResistance { get { return 5; } }
        public override int BaseEnergyResistance { get { return 0; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkJesterSuit() : this( 0 )
		{
		}

		[Constructable]
		public SilkJesterSuit( int hue ) : base( 0x1F9F, hue )
		{
            Weight = 4.0;
            Name = "Silk Jester Suit";
		}

        public SilkJesterSuit(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x27A1, 0x27EC )]
	public class SilkJinBaori : BaseSilkMiddleTorso
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 3; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkJinBaori() : this( 0 )
		{
		}

		[Constructable]
		public SilkJinBaori( int hue ) : base( 0x27A1, hue )
		{
			Weight = 3.0;
            Name = "Silk Jin Baori";
		}

        public SilkJinBaori(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}